;
;***********************
;       DEMO LCD       *
;     EXPERIMENT 0AH   *
;***********************

           CPU  "Z80.TBL"
           HOF  "INT8"

           ORG  2000H
WR_COMM:   EQU  0ACH          ;LCD command port write
RD_COMM:   EQU  0ADH          ;LCD command port read
WR_DAT:    EQU  0AEH          ;LCD data port write
DELAY:     EQU  0FH
SYSCAL:    EQU  10H
;
START:     LD   A,00111000B  ;Function set
           CALL LCD_COM
           LD   A,00001111B  ;Display on/off control
           CALL LCD_COM
           LD   A,00000110B  ;Entrey mode set
           CALL LCD_COM

START1:    LD   A,1          ;Clear LCD
           CALL LCD_COM
;
           LD   HL,TAB1
           CALL BLOCKI

           LD   A,4          ;cursor dec
           CALL LCD_COM
           LD   A,0C0H+19
           CALL LCD_COM

           LD   HL,TAB2+19
           CALL BLOCKD
           LD   B,0
           LD   A,DELAY
           RST  SYSCAL
;
           LD   A,7          ;shift right
           CALL LCD_COM
           LD   C,40         ;shift 2 screen
START2:    LD   A,1CH
           CALL LCD_COM
           LD   A,DELAY
           LD   B,80H
           RST  SYSCAL
           DEC  C
           JR   NZ,START2
;
           LD   B,0
           LD   A,DELAY
           RST  SYSCAL

           LD   A,5          ;shift right
           CALL LCD_COM
           LD   C,40         ;shift 2 screen
START3:    LD   A,18H
           CALL LCD_COM
           LD   A,DELAY
           LD   B,80H
           RST  SYSCAL
           DEC  C
           JR   NZ,START3
           JR   START

;
;***********************
;    SUB ROUTINE LCD   *
;***********************
;/* write command */
;  I/P = A

LCD_COM:   CALL BUSY
           OUT  (WR_COMM),A
           RET

;/* write ascii of LCD */
;  I/P = D

WR_ASCII:  CALL BUSY
           LD   A,D
           OUT  (WR_DAT),A
           RET

;/* read busy flag */

BUSY:      PUSH AF
BUSY1:     IN   A,(RD_COMM)
           BIT  7,A          ;Bit is busy
           JR   NZ,BUSY1     ;not busy loop
           POP  AF
           RET               ;yes busy
;
BLOCK:     LD   D,(HL)
           CALL WR_ASCII
           LD   B,40H
           LD   A,DELAY
           RST  SYSCAL
           RET

BLOCKI:    LD   E,20
BLO_I1:    CALL BLOCK
           INC  HL
           DEC  E
           JR   NZ,BLO_I1
           RET
;
BLOCKD:    LD   E,20
BLO_D1:    CALL BLOCK
           DEC  HL
           DEC  E
           JR   NZ,BLO_D1
           RET

;
TAB1:      DFB  "*LCD-20__CHARACTERS*"
TAB2:      DFB  "demo use instruction"
           END

